/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:ServerSideJMSTestCase.java,v 1.0, 2005-06-24 19:15:56Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.axis.client.Call;
import org.jboss.axis.configuration.FileProvider;
import org.jboss.axis.encoding.XMLType;
import org.jboss.axis.transport.jms.JMSConstants;
import org.jboss.axis.transport.jms.JMSTransport;
import org.jboss.test.JBossTestCase;

import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import java.io.ByteArrayInputStream;
import java.util.HashMap;


/**
 * A web service client that connects to a MDB endpoint using
 * the dynamic invokation interface (DII).
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class ServerSideJMSTestCase extends JBossTestCase
{
   private static final String ENDPOINT_QUEUE = "queue/MessageDrivenEndpointQueue";
   private static final String TARGET_NAMESPACE = "http://org.jboss.test.webservice/samples";

   public ServerSideJMSTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ServerSideJMSTestCase.class, "ws4ee-samples-server-jms.jar");
   }

   /**
    * Construct an Axis call and use JMSTransport to send it to the specified queue
    */
   public void testSOAPMessageToEndpointQueue() throws Exception
   {
      // create the transport
      InitialContext ctx = new InitialContext();
      HashMap ctxEnv = new HashMap(ctx.getEnvironment());
      ctxEnv.put("transport.jms.ConnectionFactoryJNDIName", "UIL2ConnectionFactory");
      JMSTransport transport = new JMSTransport(null, ctxEnv);

      String clientConfig =
              "<deployment name='JMS Test' xmlns='http://xml.apache.org/axis/wsdd/'" +
              "    xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'>" +
              "  <handler name='JMSSender' type='java:org.jboss.axis.transport.jms.JMSSender' />" +
              "  <transport name='JMSTransport' pivot='JMSSender'/>" +
              "</deployment>";
      try
      {
         // create a new Call object
         FileProvider config = new FileProvider(new ByteArrayInputStream(clientConfig.getBytes()));
         org.jboss.axis.client.Service service = new org.jboss.axis.client.Service(config);
         Call call = (Call)service.createCall();

         call.setOperationName(new QName(TARGET_NAMESPACE, "getContactInfo"));
         call.addParameter("organization", XMLType.XSD_STRING, ParameterMode.IN);
         call.setReturnType(XMLType.XSD_STRING);
         call.setProperty(JMSConstants.DESTINATION, ENDPOINT_QUEUE);
         call.setTimeout(new Integer(1000));
         call.setTransport(transport);

         String info = (String)call.invoke(new String[]{"mafia"});
         assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
      }
      finally
      {
         transport.shutdown();
      }
   }
}
