/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:ServerSideEJBTestCase.java,v 1.0, 2005-06-24 19:15:56Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;


/**
 * A web service client that connects to a SLSB endpoint using
 * the dynamic invokation interface (DII).
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class ServerSideEJBTestCase extends JBossTestCase
{
   public ServerSideEJBTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ServerSideEJBTestCase.class, "ws4ee-samples-server-ejb.jar");
   }

   public void testEJBEndpointAccess() throws Exception
   {
      URL url = new URL("http://localhost:8080/ws4ee-samples-server-ejb/Organization?wsdl");
      QName qname = new QName("http://org.jboss.test.webservice/samples", "OrganizationService");
      ServiceFactory factory = ServiceFactory.newInstance();
      Service service = factory.createService(url, qname);

      Organization endpoint = (Organization)service.getPort(Organization.class);
      String info = endpoint.getContactInfo("mafia");
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }
}
