/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.message;

// $Id:MessageTestCase.java,v 1.0, 2005-06-24 19:12:21Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.Service;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.net.URL;

/**
 * Test unstructured message processing
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class MessageTestCase extends WebserviceTestBase
{
   private final String TARGET_ENDPOINT = "http://" + getServerHost() + ":8080/ws4ee-message";

   public MessageTestCase(String name)
   {
      super(name);
   }

   /** Use the SAAJ API to send the SOAP message.
    * This simulates an external client and tests server side message handling.
    */
   public void testSAAJClientFromEnvelope() throws Exception
   {
      MessageFactory mf = MessageFactory.newInstance();
      SOAPMessage reqMsg = mf.createMessage();

      DocumentBuilder builder = getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(Message.request.getBytes()));
      reqMsg.getSOAPBody().addDocument(doc);

      SOAPConnectionFactory conFactory = SOAPConnectionFactory.newInstance();
      SOAPConnection con = conFactory.createConnection();
      SOAPMessage resMsg = con.call(reqMsg, new URL(TARGET_ENDPOINT));

      SOAPBody soapBody = resMsg.getSOAPBody();
      SOAPElement soapElement = (SOAPElement)soapBody.getChildElements().next();

      validateResponse(soapElement);
   }

   /** Use the SAAJ API to send the SOAP message.
    * This simulates an external client and tests server side message handling.
    */
   public void testSAAJClientFromBody() throws Exception
   {
      MessageFactory mf = MessageFactory.newInstance();
      SOAPMessage reqMsg = mf.createMessage();

      DocumentBuilder builder = getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(Message.request.getBytes()));
      reqMsg.getSOAPBody().addDocument(doc);

      SOAPConnectionFactory conFactory = SOAPConnectionFactory.newInstance();
      SOAPConnection con = conFactory.createConnection();
      SOAPMessage resMsg = con.call(reqMsg, new URL(TARGET_ENDPOINT));

      SOAPBody soapBody = resMsg.getSOAPBody();
      SOAPElement soapElement = (SOAPElement)soapBody.getChildElements().next();

      validateResponse(soapElement);
   }

   /** Use the JBoss generated dynamic proxy send the SOAP message.
    * This tests server/client side message handling.
    */
   public void testProcessElement() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/MessageService");
      Message port = (Message)service.getPort(Message.class);

      DocumentBuilder builder = getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(Message.request.getBytes()));
      Element reqElement = doc.getDocumentElement();

      SOAPElement resElement = (SOAPElement)port.processElement(reqElement);
      validateResponse(resElement);
   }


   private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException
   {
      // Setup document builder
      DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
      docBuilderFactory.setNamespaceAware(true);

      DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
      return builder;
   }

   private void validateResponse(SOAPElement soapElement)
           throws SOAPException
   {
      SOAPFactory factory = SOAPFactory.newInstance();

      Name expName = factory.createName("Response", Message.PREFIX_1, Message.NSURI_1);
      Name elementName = soapElement.getElementName();
      assertEquals(expName, elementName);

      expName = factory.createName("POID");
      soapElement = (SOAPElement)soapElement.getChildElements(expName).next();
      elementName = soapElement.getElementName();
      assertEquals(expName, elementName);

      String elementValue = soapElement.getValue();
      assertEquals("12345", elementValue);

      expName = factory.createName("Status");
      soapElement = (SOAPElement)soapElement.getNextSibling();
      elementName = soapElement.getElementName();
      assertEquals(expName, elementName);

      elementValue = soapElement.getValue();
      assertEquals("ok", elementValue);
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(MessageTestCase.class, "ws4ee-message.war, ws4ee-message-client.jar");
   }
}
