/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.marshalltest.types;

import java.util.Arrays;

public class Bean implements java.io.Serializable
{
   static final long serialVersionUID = 6584528323279029461L;
   private int x;
   private int y;
   private byte[] base64;

   public Bean()
   {
   }

   public int getX()
   {
      return x;
   }

   public void setX(int x)
   {
      this.x = x;
   }

   public int getY()
   {
      return y;
   }

   public void setY(int y)
   {
      this.y = y;
   }

   public byte[] getBase64()
   {
      return base64;
   }

   public void setBase64(byte[] base64)
   {
      this.base64 = base64;
   }

   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (!(o instanceof Bean)) return false;

      final Bean bean = (Bean)o;

      if (x != bean.x) return false;
      if (y != bean.y) return false;
      if (!Arrays.equals(base64, bean.base64)) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = x;
      result = 29 * result + y;
      return result;
   }

   public String toString()
   {
      String str = (base64 != null ? new String(base64) : null);
      return "[x=" + x + ",y=" + y + ",base64=" + str + "]";
   }
}
