/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.marshalltest;

// $Id:MarshallDocLiteralTestCase.java,v 1.0, 2005-06-24 19:11:37Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;
import org.jboss.test.webservice.marshalltest.types.Bean;
import org.jboss.test.webservice.marshalltest.types.BigDecimalArr;
import org.jboss.test.webservice.marshalltest.types.BigIntegerArr;
import org.jboss.test.webservice.marshalltest.types.BooleanArr;
import org.jboss.test.webservice.marshalltest.types.ByteArr;
import org.jboss.test.webservice.marshalltest.types.CalendarArr;
import org.jboss.test.webservice.marshalltest.types.DoubleArr;
import org.jboss.test.webservice.marshalltest.types.FloatArr;
import org.jboss.test.webservice.marshalltest.types.IntegerArr;
import org.jboss.test.webservice.marshalltest.types.LongArr;
import org.jboss.test.webservice.marshalltest.types.QNameArr;
import org.jboss.test.webservice.marshalltest.types.ShortArr;
import org.jboss.test.webservice.marshalltest.types.StringArr;

import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

/**
 * Tests of the ws4ee doc/literal marshalling
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-May-2004
 */
public class MarshallDocLiteralTestCase extends WebserviceTestBase
{
   protected static MarshallDocServiceInterface docPort;

   /**
    * Construct the test case with a given name
    */
   public MarshallDocLiteralTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(MarshallDocLiteralTestCase.class, "ws4ee-marshall-doclit.ear");
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      if (docPort == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/MarshallDocLitService");
         docPort = (MarshallDocServiceInterface)service.getPort(MarshallDocServiceInterface.class);
      }
   }

   public void testEchoString() throws Exception
   {
      Object ret = docPort.echoString("Hello");
      assertEquals("Hello", ret);

      ret = docPort.echoString("");
      assertEquals("", ret);

      ret = docPort.echoString(null);
      assertNull(ret);
   }

   public void testEchoInteger() throws Exception
   {
      Object ret = docPort.echoInteger(new BigInteger("100"));
      assertEquals(new BigInteger("100"), ret);

      ret = docPort.echoInteger(null);
      assertNull(ret);
   }

   public void testEchoInt() throws Exception
   {
      int ret = docPort.echoInt(100);
      assertEquals(100, ret);
   }

   public void testEchoLong() throws Exception
   {
      long ret = docPort.echoLong(100);
      assertEquals(100, ret);
   }

   public void testEchoShort() throws Exception
   {
      short ret = docPort.echoShort((short)100);
      assertEquals((short)100, ret);
   }

   public void testEchoDecimal() throws Exception
   {
      Object ret = docPort.echoDecimal(new BigDecimal("100"));
      assertEquals(new BigDecimal("100"), ret);

      ret = docPort.echoDecimal(null);
      assertNull(ret);
   }

   public void testEchoFloat() throws Exception
   {
      float ret = docPort.echoFloat((float)100.3);
      assertEquals(100.3, ret, 0.0001);
   }

   public void testEchoDouble() throws Exception
   {
      double ret = docPort.echoDouble(100.7);
      assertEquals(100.7, ret, 0.0001);
   }

   public void testEchoBoolean() throws Exception
   {
      boolean ret = docPort.echoBoolean(true);
      assertEquals(true, ret);
   }

   public void testEchoByte() throws Exception
   {
      byte ret = docPort.echoByte((byte)0x6a);
      assertEquals((byte)0x6a, ret);
   }

   public void testEchoQName() throws Exception
   {
      Object ret = docPort.echoQName(new QName("uri", "local"));
      assertEquals(new QName("uri", "local"), ret);

      ret = docPort.echoQName(null);
      assertNull(ret);
   }

   public void testEchoDateTimeCalendar() throws Exception
   {
      Calendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
      Calendar ret = docPort.echoDateTimeCalendar(cal);
      assertEquals(cal.getTime(), ret.getTime());
      assertEquals(cal.get(Calendar.ZONE_OFFSET), ret.get(Calendar.ZONE_OFFSET));

      ret = docPort.echoDateTimeCalendar(null);
      assertNull(ret);
   }

   public void testEchoDateTimeDate() throws Exception
   {
      Date date = new Date();
      Date ret = docPort.echoDateTimeDate(date);
      assertEquals(date.getTime(), ret.getTime());

      ret = docPort.echoDateTimeDate(null);
      assertNull(ret);
   }

   public void testEchoDateCalendar() throws Exception
   {
      Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Asia/Hong_Kong"));
      cal.clear();
      cal.set(2004, 11, 21);
      Calendar ret = docPort.echoDateCalendar(cal);
      assertEquals(cal.getTime().getTime(), ret.getTime().getTime());
      assertEquals(cal.get(Calendar.ZONE_OFFSET), ret.get(Calendar.ZONE_OFFSET));

      ret = docPort.echoDateCalendar(null);
      assertNull(ret);
   }

   public void testEchoDateDate() throws Exception
   {
      Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
      cal.clear();
      cal.set(2004, 11, 21);
      Date ret = docPort.echoDateDate(cal.getTime());
      assertEquals(cal.getTime().getTime(), ret.getTime());

      ret = docPort.echoDateDate(null);
      assertNull(ret);
   }

   public void testEchoBase64Binary() throws Exception
   {
      byte[] bytes = "Hello world!".getBytes();
      Object ret = docPort.echoBase64Binary(bytes);
      assertEquals("Hello world!", new String((byte[])ret));

      ret = docPort.echoBase64Binary(null);
      assertNull(ret);
   }

   public void testEchoHexBinary() throws Exception
   {
      byte[] bytes = "Hello world!".getBytes();
      Object ret = docPort.echoHexBinary(bytes);
      assertEquals("Hello world!", new String((byte[])ret));

      ret = docPort.echoHexBinary(null);
      assertNull(ret);
   }

   public void testEchoBean() throws Exception
   {
      Bean bean = new Bean();
      bean.setX(1);
      bean.setY(2);
      bean.setBase64("base64".getBytes());

      Object ret = docPort.echoBean(bean);
      assertEquals(bean, ret);

      ret = docPort.echoBean(null);
      assertNull(ret);
   }

   // See: http://jira.jboss.com/jira/browse/JBWS-30
   public void testEchoBeanNullProperties() throws Exception
   {
      Bean bean = new Bean();

      // Test null byte array
      Object ret = docPort.echoBean(bean);
      assertEquals(bean, ret);

      // Test empty byte array
      bean.setBase64(new byte[0]);

      ret = docPort.echoBean(bean);
      assertEquals(bean, ret);
   }

   public void testEchoStringArray() throws Exception
   {
      StringArr arr = new StringArr();
      arr.setStringArr(new String[]{"Hello", "world", "!"});
      Object ret = docPort.echoStringArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoIntegerArray() throws Exception
   {
      BigIntegerArr arr = new BigIntegerArr();
      arr.setBigIntegerArr(new BigInteger[]{new BigInteger("1"), new BigInteger("0"), new BigInteger("-1")});
      Object ret = docPort.echoIntegerArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoIntArray() throws Exception
   {
      IntegerArr arr = new IntegerArr();
      arr.setIntegerArr(new int[]{1, 0, -1});
      Object ret = docPort.echoIntArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoLongArray() throws Exception
   {
      LongArr arr = new LongArr();
      arr.setLongArr(new long[]{1, 0, -1});
      Object ret = docPort.echoLongArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoShortArray() throws Exception
   {
      ShortArr arr = new ShortArr();
      arr.setShortArr(new short[]{1, 0, -1});
      Object ret = docPort.echoShortArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoDecimalArray() throws Exception
   {
      BigDecimalArr arr = new BigDecimalArr();
      arr.setBigDecimalArr(new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0"), new BigDecimal("-1")});
      Object ret = docPort.echoDecimalArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoFloatArray() throws Exception
   {
      FloatArr arr = new FloatArr();
      arr.setFloatArr(new float[]{1, 0, -1});
      Object ret = docPort.echoFloatArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoDoubleArray() throws Exception
   {
      DoubleArr arr = new DoubleArr();
      arr.setDoubleArr(new double[]{1, 0, -1});
      Object ret = docPort.echoDoubleArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoBooleanArray() throws Exception
   {
      BooleanArr arr = new BooleanArr();
      arr.setBooleanArr(new boolean[]{true, false, true});
      Object ret = docPort.echoBooleanArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoByteArray() throws Exception
   {
      ByteArr arr = new ByteArr();
      arr.setByteArr(new byte[]{1, 0, -1});
      Object ret = docPort.echoByteArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoQNameArray() throws Exception
   {
      QNameArr arr = new QNameArr();
      arr.setQnameArr(new QName[]{new QName("uri", "loc1"), new QName("uri", "loc2"), new QName("uri", "loc3")});
      Object ret = docPort.echoQNameArray(arr);
      assertEquals(arr, ret);
   }

   public void testEchoDateTimeArray() throws Exception
   {
      CalendarArr arr = new CalendarArr();
      Calendar cal1 = new GregorianCalendar(2004, 5, 10);
      Calendar cal2 = new GregorianCalendar(2004, 5, 11);
      Calendar cal3 = new GregorianCalendar(2004, 5, 12);
      arr.setCalendarArr(new Calendar[]{cal1, cal2, cal3});
      Object ret = docPort.echoDateTimeArray(arr);
      assertEquals(arr, ret);
   }
}
