/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws84;

// $Id:MessageJavaBean.java,v 1.0, 2005-06-24 19:12:14Z, Robert Worsnop$

import com.ibm.wsdl.util.xml.DOM2Writer;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;

/**
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class MessageJavaBean implements Message
{
   // provide logging
   private final Logger log = Logger.getLogger(MessageJavaBean.class);

   /** javax.xml.soap.SOAPElement
    */
   public SOAPElement processSOAPElement(SOAPElement reqElement) throws RemoteException
   {
      StringWriter swr = new StringWriter();
      DOM2Writer.serializeAsXML(reqElement, swr);
      log.info("processSOAPElement: " + swr);

      try
      {
         SOAPFactory soapFactory = SOAPFactory.newInstance();

         Name name = soapFactory.createName("Order", PREFIX, NAMESPACE_URI);
         Name elementName = reqElement.getElementName();
         if (name.equals(elementName) == false)
            throw new IllegalArgumentException("Unexpected element: " + elementName);

         name = soapFactory.createName("Customer");
         reqElement = (SOAPElement)reqElement.getChildElements(name).next();
         String elementValue = reqElement.getValue();
         if ("Customer".equals(reqElement.getLocalName()) && "Kermit".equals(elementValue) == false)
            throw new IllegalArgumentException("Unexpected element value: " + elementValue);

         reqElement = (SOAPElement)reqElement.getNextSibling();
         elementValue = reqElement.getValue();
         if ("Item".equals(reqElement.getLocalName()) && "Ferrari".equals(elementValue) == false)
            throw new IllegalArgumentException("Unexpected element value: " + elementValue);

         MessageFactory msgFactory = MessageFactory.newInstance();
         SOAPMessage resMessage = msgFactory.createMessage();
         SOAPBody soapBody = resMessage.getSOAPBody();

         DocumentBuilder builder = getDocumentBuilder();
         Document doc = builder.parse(new ByteArrayInputStream(Message.response.getBytes()));
         soapBody.addDocument(doc);

         SOAPElement resElement = (SOAPElement)soapBody.getChildElements().next();
         return resElement;
      }
      catch (RuntimeException e)
      {
         throw e;
      }
      catch (Exception e)
      {
         throw new RemoteException(e.toString(), e);
      }
   }

   private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException
   {
      // Setup document builder
      DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
      docBuilderFactory.setNamespaceAware(true);

      DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
      return builder;
   }
}
