/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws68;


/** A custom data object class that needs to specify a custom serializer
 */
public class UserType implements java.io.Serializable
{
   static final long serialVersionUID = 7301010660998823851L;
   private String msg;

   public UserType()
   {
      this(null);
   }

   public UserType(String msg)
   {
      this.msg = msg;
   }

   public String getMsg()
   {
      return this.msg;
   }

   public void setMsg(String msg)
   {
      this.msg = msg;
   }

   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (!(o instanceof UserType)) return false;

      final UserType userType = (UserType)o;

      if (msg != null ? !msg.equals(userType.msg) : userType.msg != null) return false;

      return true;
   }

   public int hashCode()
   {
      return (msg != null ? msg.hashCode() : 0);
   }

   public String toString()
   {
      return "[msg=" + msg + "]";
   }
}
