/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.header;

import org.jboss.logging.Logger;

import java.rmi.RemoteException;

/**
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class SimpleHeaderEndpointImpl implements SimpleHeaderEndpoint
{
   // provide logging
   private final Logger log = Logger.getLogger(SimpleHeaderEndpointImpl.class);

   public boolean doStuff(String parameter, String header) throws RemoteException
   {
      if (parameter == null)
         throw new IllegalArgumentException("Null parameter");

      if (header == null)
         throw new IllegalArgumentException("Null header");

      log.info("username: " + header);

      return true;
   }
}
