/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.handlerflow;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Feed back the tracker messages
 */
public class HelloFeedbackServlet extends HttpServlet
{

   protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
   {
      if (req.getParameter("clear") != null)
      {
         HandlerTracker.clear();
      }
      else
      {
         res.setContentType("text/plain");
         PrintWriter pw = res.getWriter();

         String[] protocol = HandlerTracker.getProtocol();
         for (int i = 0; i < protocol.length; i++)
         {
            pw.println(protocol[i]);
         }
         pw.close();
      }
   }
}
