/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.encstyle;

// $Id:EncStyleTestCase.java,v 1.0, 2005-06-24 19:03:30Z, Robert Worsnop$

import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

/**
 * Test [ 1041408 ] WebService clients don't work with document style wsdl
 *
 * @author Thomas.Diesler@jboss.org
 * @since 11-Nov-2004
 */
public class EncStyleTestCase extends WebserviceTestBase
{
   public EncStyleTestCase(String name)
   {
      super(name);
   }

   /** Test document style */
   public void testDocStyle() throws Exception
   {
      deploy("ws4ee-encstyle-doc.war");
      deploy("ws4ee-encstyle-doc-client.jar");

      doWebServiceTest();

      undeploy("ws4ee-encstyle-doc-client.jar");
      undeploy("ws4ee-encstyle-doc.war");
   }

   /** Test rpc style */
   public void testRpcStyle() throws Exception
   {
      deploy("ws4ee-encstyle-rpc.war");
      deploy("ws4ee-encstyle-rpc-client.jar");

      doWebServiceTest();

      undeploy("ws4ee-encstyle-rpc-client.jar");
      undeploy("ws4ee-encstyle-rpc.war");
   }

   private void doWebServiceTest()
           throws NamingException, ServiceException, java.rmi.RemoteException
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/SampleService");
      SampleEndpoint port = (SampleEndpoint)service.getPort(SampleEndpoint.class);

      UserType user = new UserType();
      user.setFirstName("John");
      user.setLastName("Smith");
      String retStr = port.changeSalary(user, new Integer(5000));
      assertEquals("Hello John Smith! Your salary is: 5000", retStr);
   }
}
