/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.admindevel;

// $Id:HelloJSEImpl.java,v 1.0, 2005-06-24 19:05:25Z, Robert Worsnop$


/**
 * The typical Hello Bean this time as a web-service.
 */
public class HelloJSEImpl
{
   public String helloString(String name)
   {
      return "Hello " + name + "!";
   }

   public HelloObj helloBean(HelloObj bean)
   {
      String msg = helloString(bean.getMsg());
      HelloObj hro = new HelloObj(msg);
      return hro;
   }

   public HelloObj[] helloArray(HelloObj[] query)
   {
      HelloObj[] reply = new HelloObj[query.length];
      for (int n = 0; n < query.length; n++)
      {
         HelloObj hello = (HelloObj)query[n];
         String msg = helloString(hello.getMsg());
         HelloObj hro = new HelloObj(msg);
         reply[n] = hro;
      }
      return reply;
   }
}
