/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.admindevel;

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/** A test for the examples from the JBoss Admin Devel book.
 *
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */
public class ExampleTestCase extends WebserviceTestBase
{
   private Hello helloPort;

   public ExampleTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ExampleTestCase.class, "ws4ee-admindevel.jar, ws4ee-admindevel-client.jar");
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      helloPort = (Hello)service.getPort(Hello.class);
   }

   public void testHelloString() throws Exception
   {

      String retStr = helloPort.helloString("Kermit");
      assertEquals("Hello Kermit!", retStr);
   }

   public void testHelloBean() throws Exception
   {
      HelloObj ho = new HelloObj("Kermit");
      HelloObj hro = helloPort.helloBean(ho);
      assertEquals("Hello Kermit!", hro.getMsg());
   }

   public void testHelloArray() throws Exception
   {
      HelloObj[] query = new HelloObj[3];
      HelloObj ho = new HelloObj();
      ho.setMsg("Kermit");
      query[0] = ho;
      ho = new HelloObj();
      ho.setMsg("Piggy");
      query[1] = ho;
      ho = new HelloObj();
      ho.setMsg("Fozzy");
      query[2] = ho;

      HelloObj[] reply = helloPort.helloArray(query);
      for (int i = 0; i < reply.length; i++)
      {
         HelloObj replyObj = reply[i];
         assertEquals("Hello " + query[i].getMsg() + "!", replyObj.getMsg());
      }
   }
}
