/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.web.test.ssl;

import java.net.HttpURLConnection;

import junit.framework.Test;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossTestCase;

/** Tests of ssl and CLIENT-CERT auth
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SSLUnitTestCase extends JBossTestCase
{
   private String baseHttpNoAuth = "http://localhost:" + Integer.getInteger("web.port", 8080) + "/"; 
   private String baseHttpsNoAuth = "https://localhost:" + Integer.getInteger("secureweb.port", 8443) + "/"; 

   public SSLUnitTestCase(String name)
   {
      super(name);
   }

   /** Test that access of the transport constrained redirects to the ssl connector
    * 
    * @throws Exception
    */ 
   public void testHttpRedirect() throws Exception
   {
      log.info("+++ testHttpRedirect");
      doHttpRedirect(baseHttpNoAuth);
   }
   /** Test that access of the transport constrained redirects to the ssl connector
    * when using the SecurityDomain based connector config.
    * 
    * @throws Exception
    */ 
   public void testHttpRedirectSecurityDomain() throws Exception
   {
      log.info("+++ testHttpRedirectSecurityDomain");
      int port = Integer.getInteger("web.port", 8080).intValue();
      port += 1000;
      String httpNoAuth = "http://localhost:" + port + "/";
      doHttpRedirect(httpNoAuth);
   }

   /** Test that access of the transport constrained 
    * 
    * @throws Exception
    */ 
   public void testHttps() throws Exception
   {
      log.info("+++ testHttps");
      doHttps(baseHttpsNoAuth);
   }
   public void testHttpsSecurityDomain() throws Exception
   {
      log.info("+++ testHttps");
      int port = Integer.getInteger("secureweb.port", 8443).intValue();
      port += 1000;
      String httpsNoAuth = "https://localhost:" + port + "/";
      doHttps(httpsNoAuth);
   }

   private void doHttpRedirect(String httpNoAuth) throws Exception
   {
      log.info("+++ testHttpRedirect, httpNoAuth="+httpNoAuth);
      // Start by accessing the secured index.html of war1
      HttpClient httpConn = new HttpClient();
      String url = httpNoAuth+"clientcert-auth/unrestricted/SecureServlet";
      log.info("Accessing: "+url);
      GetMethod get = new GetMethod(url);
      int responseCode = httpConn.executeMethod(get);
      String status = get.getStatusText();
      log.debug(status);
      assertTrue("Get HTTP_MOVED_TEMP("+responseCode+")", responseCode == HttpURLConnection.HTTP_MOVED_TEMP);

      Header hdr = get.getResponseHeader("Location");
      url = hdr.getValue();
      get = new GetMethod(url);
      responseCode = httpConn.executeMethod(get);
      status = get.getStatusText();
      log.debug(status);
      assertTrue("Get OK("+responseCode+")", responseCode == HttpURLConnection.HTTP_OK);
   }
   public void doHttps(String httpsNoAuth) throws Exception
   {
      log.info("+++ doHttps, httpsNoAuth="+httpsNoAuth);
      // Start by accessing the secured index.html of war1
      HttpClient httpConn = new HttpClient();
      String url = httpsNoAuth+"clientcert-auth/unrestricted/SecureServlet";
      log.info("Accessing: "+url);
      GetMethod get = new GetMethod(url);
      int responseCode = httpConn.executeMethod(get);
      String status = get.getStatusText();
      log.debug(status);
      assertTrue("Get OK("+responseCode+")", responseCode == HttpURLConnection.HTTP_OK);
   }

   /** One time setup for all SingleSignOnUnitTestCase unit tests
    */
   public static Test suite() throws Exception
   {
      Test suite = getDeploySetup(SSLUnitTestCase.class, "clientcert-auth.war");
      return suite;
   }
}
