/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.web.test;

import junit.framework.Test;
import org.jboss.test.JBossClusteredTestCase;


/** Tests of web app single sign-on in a clustered environment
 * 
 * @author Brian Stansberry
 * @version $Revision:1$
 */
public class ClusteredSingleSignOnUnitTestCase 
      extends JBossClusteredTestCase
{   
   public ClusteredSingleSignOnUnitTestCase(String name)
   {
      super(name);
   }

   /** One time setup for all ClusteredSingleSignOnUnitTestCase unit tests
    */
   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(ClusteredSingleSignOnUnitTestCase.class,
            "web-sso.ear");
      return t1;
   }

   /** Test single sign-on across two web apps using form based auth
    * 
    * @throws Exception
    */ 
   public void testFormAuthSingleSignOn() throws Exception
   {
      log.info("+++ testFormAuthSingleSignOn");
      String[] httpURLs  = super.getHttpURLs();

      String serverA = httpURLs[0];
      String serverB = httpURLs[1];
      log.info(System.getProperties());
      log.info("serverA: "+serverA);
      log.info("serverB: "+serverB);
      SSOBaseCase.executeFormAuthSingleSignOnTest(serverA, serverB, getLog());
   }
}
