/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.test.util;

import java.net.MalformedURLException;

import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.Arrays;
import java.util.Collection;

import org.jboss.logging.Logger;

/**
 * Logs RMI classloading activity
 * 
 * @author <a href="mailto:adrian.brock@happeningtimes.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class LoggingRMIClassLoader
   extends RMIClassLoaderSpi
{
   private static final Logger log = Logger.getLogger(LoggingRMIClassLoader.class);
   
   // Attributes ----------------------------------------------------
   
   /**
    * The JVM implementation (we delegate most work to it)
    */
   RMIClassLoaderSpi delegate = RMIClassLoader.getDefaultProviderInstance();
   
   // Constructors --------------------------------------------------

   /**
    * Required constructor
    */
   public LoggingRMIClassLoader()
   {
   }
   
   // RMIClassLoaderSpi Implementation ------------------------------

   public Class loadProxyClass(String codebase, String[] interfaces, ClassLoader cl)
      throws MalformedURLException, ClassNotFoundException
   {
      Collection c = null;
      try
      {
         if (interfaces != null)
            c = Arrays.asList(interfaces);
         Class result = delegate.loadProxyClass(codebase, interfaces, cl);
         log.debug("loadClass: codebase=" + codebase + " interfaces=" + c + " cl=" + cl + " result=" + result);
         return result;
      }
      catch (MalformedURLException e)
      {
         log.debug("loadClass: codebase=" + codebase + " interfaces=" + c + " cl=" + cl, e);
         throw e;
      }
      catch (ClassNotFoundException e)
      {
         log.debug("loadClass: codebase=" + codebase + " interfaces=" + c + " cl=" + cl, e);
         throw e;
      }
   }

   public Class loadClass(String codebase, String name, ClassLoader cl)
      throws MalformedURLException, ClassNotFoundException
   {
      try
      {
         Class result = delegate.loadClass(codebase, name, cl);
         log.debug("loadClass: codebase=" + codebase + " name=" + name + " cl=" + cl + " result=" + result);
         return result;
      }
      catch (MalformedURLException e)
      {
         log.debug("loadClass: codebase=" + codebase + " name=" + name + " cl=" + cl, e);
         throw e;
      }
      catch (ClassNotFoundException e)
      {
         log.debug("loadClass: codebase=" + codebase + " name=" + name + " cl=" + cl, e);
         throw e;
      }
   }

   public ClassLoader getClassLoader(String codebase)
      throws MalformedURLException
   {
      try
      {
         ClassLoader result = delegate.getClassLoader(codebase);
         log.debug("getClassLoader: codebase=" + codebase + " result=" + result);
         return result;
      }
      catch (MalformedURLException e)
      {
         log.debug("getClassLoader: codebase=" + codebase, e);
         throw e;
      }
   }

   public String getClassAnnotation(Class clazz)
   {
      String result = delegate.getClassAnnotation(clazz);
      log.debug("getClassAnnotation: class=" + clazz + " result=" + result);
      return result;
   }
}
