/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.txtimer.test;

// $Id:TimedMockObject.java,v 1.0, 2005-06-24 19:17:52Z, Robert Worsnop$

import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb.txtimer.EJBTimerServiceLocator;
import org.jboss.ejb.txtimer.TimerImpl;
import org.jboss.ejb.txtimer.TimerServiceImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.TxManager;

import javax.ejb.EJBException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

/**
 * Created by IntelliJ IDEA.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 07-Apr-2004
 */
public class TimedMockObject implements TimedObject
{
   // logging support
   protected static Logger log = Logger.getLogger(TimedMockObject.class);

   private int callCount;

   public int getCallCount()
   {
      return callCount;
   }

   /**
    * Invoked upon txtimer expiration.
    */
   public void ejbTimeout(Timer timer)
   {
      // this will normally happen in an interceptor
      registerTimerWithTx(timer);

      callCount ++;
      log.debug("ejbTimeout: " + callCount + ",txtimer=" + timer);

      // this will normally happen in an interceptor
      commitTx();
   }

   /**
    * Register the timer with the current Transaction
    */
   private void registerTimerWithTx(Timer timer)
   {
      try
      {
         TransactionManager transactionManager = TxManager.getInstance();
         Transaction tx = transactionManager.getTransaction();
         if (tx == null)
         {
            transactionManager.begin();
            tx = transactionManager.getTransaction();
         }

         TimerImpl txtimer = (TimerImpl) timer;
         tx.registerSynchronization(txtimer);
      }
      catch (Exception e)
      {
         throw new EJBException("Cannot register timer with Tx", e);
      }
   }

   /**
    * Commit the current Transaction
    */
   private void commitTx()
   {
      try
      {
         TransactionManager transactionManager = TxManager.getInstance();
         Transaction tx = transactionManager.getTransaction();
         tx.commit();
      }
      catch (Exception e)
      {
         throw new EJBException("Cannot commit Tx", e);
      }
   }
}
