/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.timer.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.naming.InitialContext;

import org.jboss.test.timer.interfaces.TimerSLSBHome;
import org.jboss.test.timer.interfaces.TimerSLSB;
import org.jboss.logging.Logger;

/** A servlet that creates an ejb timer in its init method to test that timer
 * restoration on receipt of the server startup event does not try to create
 * a duplicate timer from this one.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class InitTimerServlet extends HttpServlet
{
   private static Logger log = Logger.getLogger(InitTimerServlet.class);
   private static byte[] handle;

   /**
    * Start an ejb timer from within the init method.
    * 
    * @param servletConfig
    * @throws ServletException
    */ 
   public void init(ServletConfig servletConfig) throws ServletException
   {
      super.init(servletConfig);
      log.info("init, creating ejb timer");
      // 
      try
      {
         InitialContext ctx = new InitialContext();
         TimerSLSBHome home = (TimerSLSBHome) ctx.lookup("java:/comp/env/ejb/TimerSLSBHome");
         TimerSLSB bean = home.create();
         handle = bean.startTimer(60000);
      }
      catch(Exception e)
      {
         throw new ServletException(e);
      }
   }

   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      try
      {
         InitialContext ctx = new InitialContext();
         TimerSLSBHome home = (TimerSLSBHome) ctx.lookup("java:/comp/env/ejb/TimerSLSBHome");
         TimerSLSB bean = home.create();
         int timeoutCount = bean.getTimeoutCount(handle);
         Date nextTimeout = bean.getNextTimeout(handle);
         long timeRemaining = bean.getTimeRemaining(handle);
         PrintWriter pw = response.getWriter();
         pw.println("<html><head><title>InitTimerServlet</title></head><body>");
         pw.println("<h1>Timer Info</h1>");
         pw.println("TimeoutCount:"+timeoutCount);
         pw.println("<br>NextTimeout:"+nextTimeout);
         pw.println("<br>TimeRemaining:"+timeRemaining);
         pw.println("</body></html>");
      }
      catch(Exception e)
      {
         throw new ServletException(e);
      }
   }
}
