/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.timer.interfaces;

/**
 * Remote interface for test/timer/TimerSLSB.
 * @author Thomas Diesler
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface TimerSLSB
   extends javax.ejb.EJBObject
{
   /**
    * Start a single timer (if not already set) with the start date plus the period
    * @param pPeriod Time that will elapse between now and the timed event in milliseconds
    */
   public byte[] startSingleTimer( long pPeriod )
      throws java.rmi.RemoteException;

   /**
    * Start a timer (if not already set) with the start date plus the period and an interval of the given period
    * @param pPeriod Time that will elapse between two events in milliseconds
    */
   public byte[] startTimer( long pPeriod )
      throws java.rmi.RemoteException;

   public void stopTimer(byte[] handle)
      throws java.rmi.RemoteException;

   public int getTimeoutCount(byte[] handle)
      throws java.rmi.RemoteException;

   public java.util.Date getNextTimeout(byte[] handle)
      throws java.rmi.RemoteException;

   public long getTimeRemaining(byte[] handle)
      throws java.rmi.RemoteException;

   public Object getInfo(byte[] handle)
      throws java.rmi.RemoteException;

}
