/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.timer.interfaces;

/**
 * @author Thomas Diesler
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface TimerEntity
   extends javax.ejb.EJBObject
{
   /**
    * Start a single timer (if not already set) with the start date plus the period
    * @param pPeriod Time that will elapse between now and the timed event in milliseconds
    */
   public void startSingleTimer( long pPeriod )
      throws java.rmi.RemoteException;

   /**
    * Start a timer (if not already set) with the start date plus the period and an interval of the given period
    * @param pPeriod Time that will elapse between two events in milliseconds
    */
   public void startTimer( long pPeriod )
      throws java.rmi.RemoteException;

   public void stopTimer(  )
      throws java.rmi.RemoteException;

   public int getTimeoutCount(  )
      throws java.rmi.RemoteException;

   public java.util.Date getNextTimeout(  )
      throws java.rmi.RemoteException;

   public long getTimeRemaining(  )
      throws java.rmi.RemoteException;

   public java.lang.Object getInfo(  )
      throws java.rmi.RemoteException;

   public javax.ejb.TimerHandle getTimerHandle(  )
      throws java.rmi.RemoteException;

}
