/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.security.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

/**
 * The target of the web constraints security tests
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class ConstraintsServlet extends HttpServlet
{
   protected void doRequest(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      Principal caller = request.getUserPrincipal();
      PrintWriter pw = response.getWriter();
      pw.write("<html>\n");
      pw.write("<br>Saw UserPrincipal: "+caller);
      pw.write("<br>PathInfo: "+request.getPathInfo());
      pw.write("</html>\n");
   }

   protected void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      doRequest(request, response);
   }

   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      doRequest(request, response);
   }
}
