/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.security.ejb;

import java.security.Principal;

/** A custom Principal implementation. This class must compare to other
 * Principals based on the Principal.getName() hashCode and equality.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class CustomPrincipalImpl
   implements Principal
{
   private String name;

   public CustomPrincipalImpl(String name)
   {
      this.name = name;
   }

   public int hashCode()
   {
      return name.hashCode();
   }

   public boolean equals(Object obj)
   {
      Principal p = (Principal) obj;
      return name.equals(p.getName());
   }

   public String toString()
   {
      return name;
   }

   /**
    * Returns the name of this principal.
    *
    * @return the name of this principal.
    */
   public String getName()
   {
      return name;
   }
}
