/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.security.ejb;

import java.security.Principal;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import org.apache.log4j.Category;
import org.jboss.test.security.interfaces.StatelessSessionLocal;
import org.jboss.test.security.interfaces.StatelessSessionLocalHome;
import org.jboss.test.security.interfaces.CalledSessionHome;
import org.jboss.test.security.interfaces.CalledSession;
import org.jboss.test.security.interfaces.CalledSessionLocalHome;
import org.jboss.test.security.interfaces.CalledSessionLocal;

/** A simple session bean that calls the CalleeBean
 
 @author Scott.Stark@jboss.org
 @version $Revision:1$
 */
public class CallerBean implements SessionBean
{
   private static Category log = Category.getInstance(CallerBean.class);
   private SessionContext sessionContext;

   public void ejbCreate() throws CreateException
   {
      log.debug("ejbCreate() called");
   }

   public void ejbActivate()
   {
      log.debug("ejbActivate() called");
   }

   public void ejbPassivate()
   {
      log.debug("ejbPassivate() called");
   }

   public void ejbRemove()
   {
      log.debug("ejbRemove() called");
   }

   public void setSessionContext(SessionContext context)
   {
      sessionContext = context;
   }

   /** This method calls echo on a StatelessSessionLocal and asserts that
    * the caller is in the EchoCaller role.
    */
   public String invokeEcho(String arg)
   {
      log.debug("echo, arg="+arg);
      Principal p = sessionContext.getCallerPrincipal();
      log.debug("echo, callerPrincipal="+p);
      boolean isEchoCaller = sessionContext.isCallerInRole("EchoCaller");
      log.debug("echo, isCallerInRole('EchoCaller')="+isEchoCaller);
      boolean isInternalRole = sessionContext.isCallerInRole("InternalRole");
      log.debug("echo, isCallerInRole('InternalRole')="+isInternalRole);
      
      if( isEchoCaller == false && isInternalRole == false )
         throw new SecurityException("isEchoCaller == false && isInternalRole == false");
      try
      {
         InitialContext ic = new InitialContext();
         Context enc = (Context) ic.lookup("java:comp/env");
         Object ref = enc.lookup("ejb/local/CalleeHome");
         StatelessSessionLocalHome localHome = (StatelessSessionLocalHome) PortableRemoteObject.narrow(ref,
               StatelessSessionLocalHome.class);
         StatelessSessionLocal localBean = localHome.create();
         String echo2 = localBean.echo(arg);
        log.debug("echo, callee.echo="+echo2);
      }
      catch(Exception e)
      {
         log.error("Failed to invoke Callee.echo", e);
         throw new EJBException("Failed to invoke Callee.echo", e);
      }
      return arg;
   }

   /** This method should call invokeEcho on another CalledSession */
   public void callEcho()
   {
      try
      {
         InitialContext ic = new InitialContext();
         Context enc = (Context) ic.lookup("java:comp/env");
         Object ref = enc.lookup("ejb/CallerHome");
         CalledSessionHome home = (CalledSessionHome) PortableRemoteObject.narrow(ref,
               CalledSessionHome.class);
         CalledSession bean = home.create();
         String echo2 = bean.invokeEcho("Level1");
        log.debug("echo, callee.invokeEcho="+echo2);
      }
      catch(Exception e)
      {
         log.error("Failed to invoke Callee.invokeEcho", e);
         throw new EJBException("Failed to invoke Callee.invokeEcho", e);
      }
      
   }
   /** This method should call invokeEcho on a CalledSession */
   public String callLocalEcho(String arg)
   {
      try
      {
         InitialContext ic = new InitialContext();
         Context enc = (Context) ic.lookup("java:comp/env");
         Object ref = enc.lookup("ejb/CallerHome");
         CalledSessionLocalHome home = (CalledSessionLocalHome) PortableRemoteObject.narrow(ref,
               CalledSessionLocalHome.class);
         CalledSessionLocal bean = home.create();
         String echo2 = bean.invokeEcho(arg+"Level1");
         log.debug("echo, callee.invokeEcho="+echo2);
         return echo2;
      }
      catch(Exception e)
      {
         log.error("Failed to invoke Callee.invokeEcho", e);
         throw new EJBException("Failed to invoke Callee.invokeEcho", e);
      }
      
   }

   public void noop()
   {
      log.debug("noop");
   }
   
}
