/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.readahead.interfaces;

import java.io.Serializable;

/**
 * Primary key class for one of the entities used in read-ahead finder tests.
 * @author <a href="mailto:danch@nvisia.com">danch (Dan Christopherson</a>
 * @version $Id:AddressPK.java,v 1.0, 2005-06-24 18:44:00Z, Robert Worsnop$
 *
 *          Revision:
 */
public class AddressPK implements Serializable
{

   static final long serialVersionUID = 9082516796672830218L;
   public String key = "";
   public String addressId = "";

   public AddressPK()
   {
   }

   public AddressPK(String key, String addressId)
   {
      this.key = key;
      this.addressId = addressId;
   }

   public boolean equals(Object obj)
   {
      if (this.getClass().equals(obj.getClass()))
      {
         AddressPK that = (AddressPK) obj;
         return this.key.equals(that.key) && this.addressId.equals(that.addressId);
      }
      return false;
   }

   public int hashCode()
   {
      return key.hashCode() + addressId.hashCode();
   }
}