/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.support;

/**
 * Checks the number of messages
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public class CheckMessageSizeOperation extends Operation
{
   protected int size;
   
   public CheckMessageSizeOperation(BasicMessageDrivenUnitTest test, int size)
   {
      super(test);
      this.size = size;
   }

   public void run() throws Exception
   {
      test.waitMessages(size);
      int actual = test.getMessages().size();
      if (actual != size)
         throw new Exception("Wrong number of messages, expected=" + size + " got=" + actual);
   }
}
