/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.support;

import javax.jms.Message;

/**
 * Check a message property
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public class CheckJMSDestinationOperation extends Operation
{
   protected int msgNo;
   protected String destination;
   
   public CheckJMSDestinationOperation(BasicMessageDrivenUnitTest test, int msgNo, String destination)
   {
      super(test);
      this.msgNo = msgNo;
      this.destination = destination;
   }

   public void run() throws Exception
   {
      Message message = (Message) test.getMessages().get(msgNo);
      String actual = message.getJMSDestination().toString();
      if (destination.equals(actual) == false)
         throw new Exception("For msgNo=" + msgNo + " destination=" + actual + " Expected=" + destination + " msg=" + message);
   }
}
