/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.messagedriven.mbeans;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

import javax.jms.Message;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.jboss.system.ServiceMBeanSupport;

/**
 * Management of the test message driven bean 
 *
 * @author <a href="mailto:adrian@jboss.com>Adrian Brock</a>
 * @version <tt>$Revision: 1.4</tt>
 */
public class TestMessageDrivenManagement extends ServiceMBeanSupport implements TestMessageDrivenManagementMBean
{
   private static final Properties defaultProps = new Properties();
   
   private TransactionManager tm;
   
   static
   {
      defaultProps.put("destination", "NotSpecified");
      defaultProps.put("destinationType", "NotSpecified");
      defaultProps.put("transactionType", "Container");
      defaultProps.put("transactionAttribute", "Required");
      defaultProps.put("rollback", "None");
      defaultProps.put("DLQMaxResent", "5");
   }
   
   protected ArrayList messages = new ArrayList();
   
   public TestMessageDrivenManagement() throws Exception
   {
      tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
   }
   
   public void initProperties(Properties props)
   {
      setProperties(defaultProps);
      setProperties(props);
   }
   
   public void addMessage(Message message)
   {
      synchronized (messages)
      {
         messages.add(message);
      }
   }
   
   public ArrayList getMessages()
   {
      synchronized (messages)
      {
         ArrayList result = new ArrayList(messages);
         messages.clear();
         return result;
      }
   }
   
   public Transaction getTransaction()
   {
      Transaction tx = null;
      try
      {
         tx = tm.getTransaction();
      }
      catch (Throwable ignored)
      {
      }
      return tx;
   }
   
   protected void setProperties(Properties props)
   {
      for (Enumeration e = props.keys(); e.hasMoreElements();)
      {
         String key = (String) e.nextElement();
         System.setProperty("test.messagedriven." + key, props.getProperty(key));
      }
   }
}
