/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.media.format.audio.oggvorbis;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

import javax.emb.Media;
import javax.emb.MediaBean;
import javax.emb.MediaFormatRegistry;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.media.format.audio.oggvorbis.OggVorbisFormat;
import org.jboss.media.format.audio.oggvorbis.OggVorbisHeader;
import org.jboss.media.util.ResourceUtils;

/**
 * Test case for parsing Ogg Vorbis headers.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 */
public class TestOggVorbisHeader extends TestCase
{
   private static final Logger log =
      Logger.getLogger(TestOggVorbisHeader.class);

   private static String RESOURCE_DIRECTORY = "media/format/data/";
   private static final String OGG_VORBIS_FILE = "jboss48k16khz.ogg";
   private static final String OGG_VORBIS_MIME_TYPE = "application/ogg";

   /**
    * Constructor for TestMpegAudioHeader.
    */
   public TestOggVorbisHeader(String name)
   {
      super(name);
   }

   public void setUp() throws Exception
   {
      MediaFormatRegistry mediaFormatRegistry = MediaFormatRegistry.SINGLETON;
      mediaFormatRegistry.bind("ogg", new OggVorbisFormat());
   }

   public void tearDown() throws Exception
   {
      MediaFormatRegistry mediaFormatRegistry = MediaFormatRegistry.SINGLETON;
      mediaFormatRegistry.unbind("ogg");
   }

   public void testGetHeaders() throws Exception
   {
      File file =
         ResourceUtils.getResourceFile(RESOURCE_DIRECTORY + OGG_VORBIS_FILE);
      Media media = new MediaBean(file, OGG_VORBIS_MIME_TYPE);
      OggVorbisHeader header = (OggVorbisHeader) media.getHeader();

      String[] fieldNames = header.getFieldNames();

      if (log.isDebugEnabled())
      {
         for (int i = 0; i < fieldNames.length; i++)
         {
            log.debug(fieldNames[i] + ": " + header.getField(fieldNames[i]));
         }
      }

      // Test headers:
      assertEquals(new Integer(1), header.getField("channels"));
      assertEquals(new Long(16000), header.getField("rate"));
      assertEquals(new Long(48000), header.getField("bitRate"));

      // Test comments:
      Hashtable comments = (Hashtable) header.getField("comments");
      Vector tracknumber = (Vector) comments.get("tracknumber");
      assertEquals("1", tracknumber.get(0));
      Vector date = (Vector) comments.get("date");
      assertEquals("November 22 2003", date.get(0));
      Vector title = (Vector) comments.get("title");
      assertEquals("JBoss Media Ogg Vorbis testing file.", title.get(0));
   }
}