/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.media.entity.ejb;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.emb.MediaEntityLocal;
import javax.emb.MediaEntityLocalHome;
import javax.naming.Context;
import javax.naming.InitialContext;

import org.apache.log4j.Category;
import org.jboss.media.entity.MediaEntityBean;

/**
 * Session Bean to test Media Entity Beans.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo Argello</a>
 * 
 * @ejb.bean type="Stateless" name="EntityMediaBeanTester" jndi-name="ejb/EntityMediaBeanTester"
 * @ejb.ejb-ref ejb-name="MediaEntity" view-type="local"
 * @ejb.transaction type="Required"
 * @ejb.transaction-type type="Container"
 */
public class EntityMediaBeanTesterBean implements SessionBean
{
   private Category log = Category.getInstance(getClass());

   private MediaEntityLocalHome entityHome;

   public static final String MEDIA_ENTITY_JNDI =
      MediaEntityBean.MEDIA_ENTITY_JNDI;

   /**
    * @ejb:interface-method view-type="remote"
    */
   public String createEntityMediaBean()
   {
      try
      {
         return (String) getMediaEntityLocalHome().create().getPrimaryKey();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new EJBException(e.getMessage());
      }
   }

   /**
    * @ejb:interface-method view-type="remote"
    */
   public void removeEntityMediaBean(String id) throws Exception
   {
      try
      {
         getMediaEntityLocalHome().remove(id);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new EJBException(e.getMessage());
      }
   }

   /**
    * @ejb:interface-method view-type="remote"
    */
   public byte[] getContent(String id) throws Exception
   {
      MediaEntityLocal entity = getMediaEntityLocalHome().findByPrimaryKey(id);

      return entity.getContent();
   }

   /**
    * @ejb:interface-method view-type="remote"
    */
   public void setContent(String id, byte[] content) throws Exception
   {
      try
      {
         getMediaEntityLocalHome().findByPrimaryKey(id).setContent(content);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new EJBException(e.getMessage());
      }
   }

   public void ejbCreate() throws CreateException
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }

   public void setSessionContext(SessionContext ctx)
   {
   }

   private MediaEntityLocalHome getMediaEntityLocalHome()
   {
      if (entityHome == null)
      {
         try
         {
            Context initialContext = new InitialContext();
            return (MediaEntityLocalHome) initialContext.lookup(
               MEDIA_ENTITY_JNDI);
         }
         catch (Exception e)
         {
            throw new EJBException("Could not lookup " + MEDIA_ENTITY_JNDI);
         }
      }

      return entityHome;
   }
}