
/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.jca.test;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.system.ServiceMBean;
import org.jboss.test.JBossTestCase;

/**
 * XADataSource unit tests case
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class XADSUnitTestCase extends JBossTestCase
{
   public XADSUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(XADSUnitTestCase.class, "jcaxadstest.jar");
   }

   public void testXADSDeployed() throws Exception
   {
      ObjectName name = new ObjectName("jboss.jca:service=DataSourceBinding,name=TestXADS");
      assertTrue("TestXADS is deployed", getServer().getAttribute(name, "State").equals(new Integer(ServiceMBean.STARTED)));
   }
}
