/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.jca.test;

import junit.framework.*;
import org.jboss.test.JBossTestCase;
import org.jboss.test.jca.interfaces.RollbackOnlyReleaseConnectionSessionHome ;
import org.jboss.test.jca.interfaces.RollbackOnlyReleaseConnectionSession ;

/**
 * RollbackOnlyReleaseConnectionUnitTestCase.java
 *
 *
 * Created: 20-Oct-2004
 *
 * @author <a href="mailto:noel.rocher@jboss.org">Noel Rocher</a>
 * @version
 */

public class RollbackOnlyReleaseConnectionUnitTestCase extends JBossTestCase
{
   private RollbackOnlyReleaseConnectionSessionHome sh;
   private RollbackOnlyReleaseConnectionSession s;


   public RollbackOnlyReleaseConnectionUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      Test t1 = getDeploySetup(RollbackOnlyReleaseConnectionUnitTestCase.class, "jcatest.jar");
      Test t2 = getDeploySetup(t1, "testadapter-ds.xml");
      return getDeploySetup(t2, "jbosstestadapter.rar");
   }

   protected void setUp() throws Exception
   {
      log.debug("================> Start " + getName());
      sh = (RollbackOnlyReleaseConnectionSessionHome)getInitialContext().lookup("RollbackOnlyReleaseConnectionSession");
      s = sh.create();
   }


   protected void tearDown() throws Exception
   {
      log.debug("================> End " + getName());
   }


// -- tests

   public void testConnectionRelease() throws Exception
   {
      assertTrue("Connections should be released when not enrolled in Tx marked rollback only", s.testConnectionRelease() == true);
   }


}// RollbackOnlyReleaseConnectionSessionBeanUnitTestCase
