/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.jca.test;

import java.net.URL;

import junit.framework.Test;
import org.jboss.test.JBossTestCase;
import org.jboss.test.jca.adminobject.TestImplementation;
import org.jboss.test.jca.adminobject.TestImplementation2;
import org.jboss.test.jca.adminobject.TestInterface;
import org.jboss.test.jca.adminobject.TestInterface2;
import org.jboss.test.jca.inflow.TestResourceAdapter;
import org.jboss.test.jca.inflow.TestResourceAdapterInflowResults;

/**
 * Inflow Unit Tests
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class AdminObjectUnitTestCase extends JBossTestCase
{

   public AdminObjectUnitTestCase (String name)
   {
      super(name);
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(AdminObjectUnitTestCase.class, "testadminobject.rar");
   }

   public void testAdminObject() throws Throwable
   {
      //assertNotBound();
      deploy("testadminobject-service.xml");
      try
      {
         Object obj = getInitialContext().lookup("test/jca/TestInterface");
         assertTrue("Instanceof TestInterface", obj instanceof TestInterface);
         assertTrue("Instanceof TestImplementation", obj instanceof TestImplementation);
         TestImplementation impl = (TestImplementation) obj;
         assertEquals("StringValue", impl.getStringProperty());
         assertEquals(new Integer(123), impl.getIntegerProperty());

         obj = getInitialContext().lookup("test/jca/TestInterface2");
         assertTrue("Instanceof TestInterface2", obj instanceof TestInterface2);
         assertTrue("Instanceof TestImplementation2", obj instanceof TestImplementation2);
         TestImplementation2 impl2 = (TestImplementation2) obj;
         assertEquals(new Integer(456), impl2.getStringProperty());
      }
      finally
      {
         undeploy("testadminobject-service.xml");
      }
      //assertNotBound();
   }

   protected void assertNotBound() throws Exception
   {
      try
      {
         getInitialContext().lookup("test/jca/TestInterface");
         fail("test/jca/TestInterface is bound");
      }
      catch (Exception expected)
      {
      }

      try
      {
         getInitialContext().lookup("test/jca/TestInterface2");
         fail("test/jca/TestInterface2 is bound");
      }
      catch (Exception expected)
      {
      }
   }
}
