/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jca.inflow;

import java.util.Iterator;
import java.util.Map;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;

/**
 * A TestResourceAdapter.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class TestResourceAdapter implements ResourceAdapter, TestResourceAdapterMBean
{
   private static final Logger log = Logger.getLogger(TestResourceAdapter.class);
   
   public static final ObjectName mbean = ObjectNameFactory.create("jboss.test:test=TestResourceAdapter");
   
   BootstrapContext ctx;

   ConcurrentReaderHashMap endpoints = new ConcurrentReaderHashMap();
   
   public TestResourceAdapterInflowResults testInflow() throws Exception
   {
      TestResourceAdapterInflow test = new TestResourceAdapterInflow(this);
      return test.run();
   }
   
   public TestResourceAdapterWorkManagerResults testWorkManager() throws Exception
   {
      TestResourceAdapterWorkManager test = new TestResourceAdapterWorkManager(this);
      return test.run();
   }
   
   public TestResourceAdapterTimerResults testTimer() throws Exception
   {
      TestResourceAdapterTimer test = new TestResourceAdapterTimer(this);
      return test.run();
   }
   
   public TestResourceAdapterTxInflowResults testTxInflow() throws Exception
   {
      TestResourceAdapterTxInflow test = new TestResourceAdapterTxInflow(this);
      return test.run();
   }
   
   public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException
   {
      MessageEndpoint endpoint = endpointFactory.createEndpoint(null);
      endpoints.put(spec, endpoint);
   }

   public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec)
   {
      MessageEndpoint endpoint = (MessageEndpoint) endpoints.remove(spec);
      if (endpoint != null)
         endpoint.release();
   }
   
   public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException
   {
      // TODO getXAResources
      return null;
   }
   
   public void start(BootstrapContext ctx) throws ResourceAdapterInternalException
   {
      this.ctx = ctx;

      try
      {
         MBeanServer server = MBeanServerLocator.locateJBoss();
         server.registerMBean(this, mbean);
      }
      catch (Exception e)
      {
         throw new ResourceAdapterInternalException(e);
      }
   }

   public void stop()
   {
      try
      {
         MBeanServer server = MBeanServerLocator.locateJBoss();
         server.unregisterMBean(mbean);
         
         for (Iterator i = endpoints.entrySet().iterator(); i.hasNext();)
         {
            Map.Entry entry = (Map.Entry) i.next();
            MessageEndpoint endpoint = (MessageEndpoint) entry.getValue();
            endpoint.release();
            i.remove();
         }
      }
      catch (Exception ignored)
      {
      }
   }
   
   MessageEndpoint getEndpoint(String name) throws Exception
   {
      for (Iterator i = endpoints.entrySet().iterator(); i.hasNext();)
      {
         Map.Entry entry = (Map.Entry) i.next();
         TestActivationSpec spec = (TestActivationSpec) entry.getKey();
         if (name.equals(spec.getName()))
            return (MessageEndpoint) entry.getValue();
      }
      throw new Exception("MessageEndpoint not found for name: " + name);      
   }
}
