/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jca.inflow;

import java.io.Serializable;

/**
 * A test result
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class Result implements Serializable
{
   static final long serialVersionUID = -8130709909888484648L;
   private boolean passed = false;
   private Throwable error;

   public void pass()
   {
      passed = true;
   }
   
   public void fail(Throwable t)
   {
      error = t;
   }
   
   public void check() throws Throwable
   {
      if (passed == false)
      {
         if (error != null)
            throw error;
         else
            throw new Exception("Failed");
      }
   }
}
