/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package org.jboss.test.jbossnet.state.server;

import org.jboss.test.util.ejb.SessionSupport;

/**
 * Stateful web service to test overriding of message scoping.
 * @author jung
 * @version $Revision:1$
 * @ejb.bean name="NoState"
 *           display-name="Stateless Count Bean"
 *           type="Stateful"
 *           view-type="remote"
 *           jndi-name="state/NoState"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.state.NoState" extends="javax.ejb.EJBObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.state.NoStateHome" extends="javax.ejb.EJBHome"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="NoState" scope="Request"
 */

public class NoStateBean
   extends SessionSupport implements javax.ejb.SessionBean
{
   protected int count=0;

   /** restore count upon pooling */
   public void ejbCreate() {
   	count=0;
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */
   
   public int count() 
   {
      return count++;
   }
}
