/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:StateUnitTestCase.java,v 1.0, 2005-06-24 19:17:00Z, Robert Worsnop$

package org.jboss.test.jbossnet.state;

import junit.framework.Test;
import org.jboss.test.jbossnet.JBossNetTestBase;

import javax.xml.namespace.QName;
import java.net.URL;

/**
 * Tests remote accessibility of stateful ejb bean
 * @since 2. Oktober 2002, 12:11
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */

public class StateUnitTestCase extends JBossNetTestBase
{
   private QName STATE_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/State", "StateService");
   private QName NOSTATE_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/NoState", "NoStateService");
   private QName FULLSTATE_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/FullState", "FullStateService");

   // Constructors --------------------------------------------------
   public StateUnitTestCase(String name)
   {
      super(name);
   }

   /** the session bean with which we interact */
   State state;
   NoState noState;
   FullState fullState;

   /** setup the bean */
   public void setUp() throws Exception
   {
      super.setUp();
      URL wsdlState = new URL(SERVICES_LOCATION + "/State?wsdl");
      URL wsdlNoState = new URL(SERVICES_LOCATION + "/NoState?wsdl");
      URL wsdlFullState = new URL(SERVICES_LOCATION + "/FullState?wsdl");

      state = (State)createService(wsdlState, STATE_SERVICE, true).getPort(State.class);
      noState = (NoState)createService(wsdlNoState, NOSTATE_SERVICE, true).getPort(NoState.class);
      fullState = (FullState)createService(wsdlFullState, FULLSTATE_SERVICE, true).getPort(FullState.class);
   }

   /** test stateful behaviour*/
   public void testState() throws Exception
   {
      assertEquals("Initial return value must be zero.", 0, state.count());
      assertEquals("Next return value must be incremented.", 1, state.count());
      assertEquals("Next return value must be incremented.", 2, state.count());
      setUp();
      assertEquals("Fresh return value must be zero.", 0, state.count());
      assertEquals("Fresh next return value must be incremented.", 1, state.count());
      assertEquals("Fresh next return value must be incremented.", 2, state.count());
   }

   /** test stateless behaviour */
   public void testNoState() throws Exception
   {
      assertEquals("Initial return value must be zero.", 0, noState.count());
      assertEquals("Next return value must not be incremented.", 0, noState.count());
      assertEquals("Next return value must not be incremented.", 0, noState.count());
   }

   /** test stateful behaviour*/
   public void testFullState() throws Exception
   {
      assertEquals("Initial return value must be zero.", 0, fullState.count());
      assertEquals("Next return value must be incremented.", 1, fullState.count());
      assertEquals("Next return value must be incremented.", 2, fullState.count());
      setUp();
      assertEquals("Fresh return value must be incremented.", 3, fullState.count());
      assertEquals("Fresh next return value must be incremented.", 4, fullState.count());
      assertEquals("Fresh next return value must be incremented.", 5, fullState.count());
   }

   /** this is to deploy the whole ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(StateUnitTestCase.class, "jbossnet-state.ear");
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(StateUnitTestCase.class);
   }

}