/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossnet.document;

// $Id:ObjectElementTestCase.java,v 1.0, 2005-06-24 19:13:12Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.axis.utils.DOM2Utils;
import org.jboss.test.jbossnet.JBossNetTestBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import java.io.ByteArrayInputStream;
import java.net.URL;

/** An endpoint test for document centric message exchange
 *
 * It uses the the jva:RPC provider with xsd:anyType
 *
 * @author Thomas.Diesler@jboss.org
 */
public class ObjectElementTestCase extends JBossNetTestBase
{
   public static final String xmlstr = "<root><child>Hello</child><child>World</child></root>";

   private String namespaceURI = "http://jboss.net/document";
   private Service service;

   public ObjectElementTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      URL wsdlURL = new URL(SERVICES_LOCATION + "/ObjectElementServer?wsdl");
      service = createService(wsdlURL, new QName(namespaceURI, "ObjectElementServerService"));
   }

   /** Process an Element at the endpoint
    */
   public void testProcessElement() throws Exception
   {
      DocumentBuilder builder = DOM2Utils.getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(xmlstr.getBytes()));
      Element rootEl = doc.getDocumentElement();

      Call call = service.createCall(new QName(namespaceURI, "ObjectElementServer"), "processElement");

      Object retObj = call.invoke(new Object[]{rootEl});
      assertNotNull("Return obj is null", retObj);
      assertTrue("Return obj is not an Element: " + retObj.getClass().getName(), retObj instanceof Element);
   }

   /** Process an Object at the endpoint
    */
   public void testProcessObject() throws Exception
   {
      DocumentBuilder builder = DOM2Utils.getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(xmlstr.getBytes()));
      Element rootEl = doc.getDocumentElement();

      Call call = service.createCall(new QName(namespaceURI, "ObjectElementServer"), "processObject");

      Object retObj = call.invoke(new Object[]{rootEl});
      assertNotNull("Return obj is null", retObj);
      assertTrue("Return obj is not an Element: " + retObj.getClass().getName(), retObj instanceof Element);
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ObjectElementTestCase.class, "jbossnet-document.wsr");
   }

}
