/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:AxisUnitTestCase.java,v 1.0, 2005-06-24 18:46:49Z, Robert Worsnop$

package org.jboss.test.jbossnet.basic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.jbossnet.JBossNetTestBase;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

/**
 * Tests remote accessibility of the main axis service servlet
 * @since 11. Oktober 2001
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */

public class AxisUnitTestCase extends JBossNetTestBase
{

   // Constructors --------------------------------------------------
   public AxisUnitTestCase(String name)
   {
      super(name);
   }

   /** tests availability of the servlet under various contexts */
   public void testServlet() throws Exception
   {
      doLegalAccess("Servlet availability", new URL("http://" + getServerHost() + ":8080/jboss-net/servlet/AxisServlet"));
      doLegalAccess("service availability", new URL("http://" + getServerHost() + ":8080/jboss-net/services"));
   }

   /** tests a successful http call to the given target */
   private void doLegalAccess(String message, URL target) throws Exception
   {
      BufferedReader reader = new BufferedReader(new InputStreamReader(target.openStream()));
      try
      {
         String line = reader.readLine();
         assertNotNull(message + " proper response", line);
      }
      finally
      {
         reader.close();
      }
   }

   public static Test suite() throws Exception
   {
      // nothing to deploy really
      return new TestSuite(AxisUnitTestCase.class);
   }
}
