/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossmq.test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestSetup;

import junit.framework.TestSuite;
import junit.framework.Test;


/**
 * JBossMQ tests over UIL2
 * @author Hiram Chirino <Cojonudo14@hotmail.com>
 */
public class UIL2JBossMQUnitTestCase
   extends JBossMQUnitTest
{
   public UIL2JBossMQUnitTestCase(String name) throws Exception
   {
      super(name);
   }
   
   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      
      suite.addTest(new JBossTestSetup(new TestSuite(UIL2JBossMQUnitTestCase.class))
      {
         protected void setUp() throws Exception
         {
            this.getLog().info("UIL2JBossMQUnitTestCase started");
            JBossMQUnitTest.TOPIC_FACTORY = "UIL2ConnectionFactory";
            JBossMQUnitTest.QUEUE_FACTORY = "UIL2ConnectionFactory";
         }
         protected void tearDown() throws Exception
         {
            this.getLog().info("UIL2JBossMQUnitTestCase done");
         }
      });

      return suite;
   }

   static public void main( String []args )
   {
      String newArgs[] = { "org.jboss.test.jbossmq.test.UIL2JBossMQUnitTestCase" };
      junit.swingui.TestRunner.main(newArgs);
   }
}
