/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.jaxr.scout.publish;

import org.jboss.test.jaxr.scout.JaxrBaseTestCase;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


/** Tests Saving ServiceBindings
 *  @author <mailto:Anil.Saldhana@jboss.org>Anil Saldhana
 *  @since  Mar 8, 2005
 */
public class JaxrSaveServiceBindingTestCase extends JaxrBaseTestCase
{
   /**
    *
    * @throws JAXRException
    */
   public void testSaveServiceBinding() throws JAXRException
   {
      String serviceName = "jbosstestService";
      String sbDescription = "jbosstest sb description";

      String conceptName = "jbosstest concept";
      Collection sbKeys = null;
      Collection serviceKeys = null;
      Collection orgKeys = null;
      Collection conceptKeys = null;
      Key conceptKey = null;
      Key serviceKey = null;
      Key orgKey = null;

      String accessURI = "http://myhost/jaxrTest.jsp";
      login();


      try
      {
         rs = connection.getRegistryService();
         blm = rs.getBusinessLifeCycleManager();
         bqm = rs.getBusinessQueryManager();
         String orgname = "Jaxr Org";
         Organization org = blm.createOrganization(getIString(orgname));
         Collection orgs = new ArrayList();
         orgs.add(org);
         BulkResponse br = blm.saveOrganizations(orgs);
         if (br.getExceptions() != null)
         {
            fail("Save Organizations failed ");
         }
         orgKeys = br.getCollection();
         Iterator iter = orgKeys.iterator();
         while (iter.hasNext())
         {
            orgKey = (Key)iter.next();
         }


         org = (Organization)bqm.getRegistryObject(orgKey.getId(), LifeCycleManager.ORGANIZATION);

         Service service = blm.createService(serviceName);
         org.addService(service);
         Collection services = new ArrayList();
         services.add(service);
         br = blm.saveServices(services);
         if (br.getExceptions() != null)
         {
            fail("Save Services failed ");
         }
         serviceKeys = br.getCollection();
         iter = serviceKeys.iterator();
         while (iter.hasNext())
         {
            serviceKey = (Key)iter.next();
         }

         service = (Service)bqm.getRegistryObject(serviceKey.getId(), LifeCycleManager.SERVICE);

         //Save some concepts
         Concept testConcept = (Concept)blm.createObject(LifeCycleManager.CONCEPT);
         testConcept.setName(blm.createInternationalString(conceptName));
         Collection concepts = new ArrayList();
         concepts.add(testConcept);
         br = blm.saveConcepts(concepts);
         if (br.getExceptions() != null)
         {
            fail("Save Concepts failed ");
         }
         conceptKeys = br.getCollection();
         iter = conceptKeys.iterator();
         while (iter.hasNext())
         {
            conceptKey = (Key)iter.next();
         }

         testConcept = (Concept)bqm.getRegistryObject(conceptKey.getId(), LifeCycleManager.CONCEPT);
         SpecificationLink sl = blm.createSpecificationLink();
         sl.setSpecificationObject(testConcept);
         ServiceBinding sb = blm.createServiceBinding();
         sb.setDescription(blm.createInternationalString(sbDescription));
         sb.setAccessURI(accessURI);
         sb.addSpecificationLink(sl);
         service.addServiceBinding(sb);
         Collection sbs = new ArrayList();
         sbs.add(sb);
         br = blm.saveServiceBindings(sbs);
         if (br.getExceptions() != null)
         {
            fail("Save ServiceBindings failed ");
         }


         Collection specifications = new ArrayList();
         specifications.add(testConcept);

         br = bqm.findServiceBindings(serviceKey, null, null, specifications);
         sbs = br.getCollection();
         iter = sbs.iterator();
         while (iter.hasNext())
         {
            sb = (ServiceBinding)iter.next();
            Service storedService = sb.getService();
            if (!(storedService.getName().getValue().equals(serviceName)))
            {
               fail("Error: service name");
            }
            Organization storedOrg = storedService.getProvidingOrganization();
            if (!(storedOrg.getName().getValue().equals(orgname)))
            {
               fail("Error: unexpected organization name \n");
            }
            if (!(sb.getDescription().getValue().equals(sbDescription)))
            {
               fail("Error: servicebinding description");
            }
            if (!(sb.getAccessURI().equals(accessURI)))
            {
               fail("Error: unexpected accessURI name");
            }
         }
      }
      catch (Exception e)
      {
         fail("Test has failed due to an exception ");
      }
      finally
      {
         try
         {
            if (conceptKeys != null)
            {
               blm.deleteConcepts(conceptKeys);
            }
            if (sbKeys != null)
            {
               blm.deleteServiceBindings(sbKeys);
            }
            if (serviceKeys != null)
            {
               blm.deleteServices(serviceKeys);
            }
            if (orgKeys != null)
            {
               blm.deleteOrganizations(orgKeys);
            }

         }
         catch (JAXRException je)
         {
            fail("Cleanup of JAXR objects failed");
         }
      }
   }
}