/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jaxr.create;

import org.jboss.test.jaxr.common.JaxrTestCase;

import javax.xml.registry.infomodel.*;
import javax.xml.registry.BulkResponse;
import java.util.ArrayList;
import java.util.Collection;

/**  Test Case that tries to create an Organization in
 *   the XML registry using Jaxr
 * @author <mailto:Anil.Saldhana@jboss.org>Anil Saldhana
 */
public class CreateOrganizationTestCase
 extends JaxrTestCase{

    protected Service service = null;
    protected ServiceBinding  binding = null;
    
    /**
     * CTR
     * @param name
     */
    public CreateOrganizationTestCase(String name) {
        super(name);
    }

    /**
     * Test that tests the creation of an Organization object
     * using JAXR
     * @throws Exception
     */
    public void  testCreateOrganization()
    throws Exception {
        authenticate();
        if( blcm == null ) blcm = this.getBusinessLifeCycleManager();
        assertNotNull("BusinessLifeCycleManager is Not Null?",blcm);
        //Clear out all old organizations with the same name in the registry
        this.clearOrganizations("JBoss");

        String id = this.createOrganization();
        /**
        Organization org = this.getOrganization("JBoss Inc", "Testing Jaxr Org");
        User user = this.getPrimaryContact("Marc Fluery");

        getLog().debug("Created User="+user.getPersonName().getFullName());

        //Email Addresses
        Collection emailadds = new ArrayList();
        emailadds.add(this.getEmailAddress("marc@jboss.org"));
        user.setEmailAddresses(emailadds);

        //Telephone Numbers
        Collection tels = new ArrayList();
        tels.add(this.getTelephoneNumber("121-121-1111"));
        user.setTelephoneNumbers(tels);

        org.setPrimaryContact(user);

        //Classifications
        Collection classifications = new ArrayList();
        classifications.add(this.getClassification("ntis-gov:naics:1997",
                                        "Software Publishers",
                                        "511210"));
        org.addClassifications(classifications);
        getLog().debug("Created Classification");

        //Services and ServiceBindings
        Collection services = new ArrayList();
        if( service == null)
            service = getService("Consulting Service","JBoss Inc provides Consulting");

        getLog().debug("Created Service");

        Collection servicebindings = new ArrayList();
        if( binding == null)
            binding = getServiceBinding("Consulting Arm",false,
                 "http://www.jboss.org" );
        servicebindings.add(binding);
        getLog().debug("Created ServiceBinding");

        getLog().debug("Adding ServiceBindings to Service");
        // Add service bindings to service
        service.addServiceBindings(servicebindings);
        getLog().debug("Added ServiceBindings to Service");

        getLog().debug("Adding Services to Org");
        //Add service
        services.add(service);
        org.addServices(services);
        getLog().debug("Added Services to Org");
        // Add organization and submit to registry
        // Retrieve key if successful
        Collection orgs = new ArrayList();
        orgs.add(org);

        getLog().debug("Going to add the Org into the registry");
        BulkResponse response = blcm.saveOrganizations(orgs);
        Collection exceptions = response.getExceptions();
        assertNull("Org Saving to Registry Successful?", exceptions );
        this.releaseConnection();
         **/
        assertNotNull("Org saved to registry?", id);
    }
    /**
     * Test creating a Service
     * @throws Exception
     */
    public void testCreateService() throws Exception {
        if( service == null )
            service = getService("Consulting Service","JBoss Inc provides Consulting");
        assertNotNull( "Service is not null?",service);
    }

    /**
     * Test creating a ServiceBinding
     * @throws Exception
     */
    public void testCreateServiceBinding() throws Exception {
        if( binding == null )
            binding = getServiceBinding("Consulting Arm",false,
                 "http://www.jboss.org" );
        assertNotNull( "ServiceBinding is not null?",binding);
    }

    //HELPER Methods
    /**
     * Creates an instance of InternationalString
     * @param str
     * @return
     * @throws Exception
     */
    protected InternationalString getIS(String str)
    throws Exception {
        if( blcm == null) blcm = this.getBusinessLifeCycleManager();
         return blcm.createInternationalString(str);
    }
    /**
     * Create a Classification object
     * @param schemename
     * @param name
     * @param value
     * @return
     * @throws Exception
     */
    protected Classification getClassification( String schemename,
                                                String name, String value)
    throws Exception {
        if( bqm == null ) bqm = this.getBusinessQueryManager();
        ClassificationScheme cscheme = bqm.findClassificationSchemeByName(null, schemename);
        return blcm.createClassification( cscheme,name,value );
    }

    /**
     * Create an Organization object
     * @param name
     * @param desc
     * @return
     * @throws Exception
     */
    protected Organization getOrganization(String name, String desc)
    throws Exception {
        if( blcm == null) blcm = this.getBusinessLifeCycleManager();
        Organization org =  blcm.createOrganization(name);
        org.setDescription(getIS(desc));
        return org;
    }
    /**
     * Create a Primary Contact
     * @param name
     * @return
     * @throws Exception
     */
    protected User getPrimaryContact(String name)
    throws Exception {
        if( blcm == null) blcm = this.getBusinessLifeCycleManager();
        User primaryContact = blcm.createUser();
        PersonName personname =  blcm.createPersonName(name);
        primaryContact.setPersonName(personname);
        return  primaryContact;
    }

    /**
     * Create a Telephone Number object
     * @param telnumb
     * @return
     * @throws Exception
     */
    protected  TelephoneNumber getTelephoneNumber(String telnumb )
    throws Exception {
        if( blcm == null) blcm = this.getBusinessLifeCycleManager();
        TelephoneNumber tnum = blcm.createTelephoneNumber();
        tnum.setNumber(telnumb);
        return tnum;
    }

    /**
     * Create an Email Address Object
     * @param email
     * @return
     * @throws Exception
     */
    protected  EmailAddress getEmailAddress(String email )
    throws Exception {
        if( blcm == null) blcm = this.getBusinessLifeCycleManager();
        EmailAddress emailaddress =
                blcm.createEmailAddress(email);
        return emailaddress;
    }
    /**
     * Create a Service
     * @param servicename
     * @param servicedesc
     * @return
     * @throws Exception
     */
    protected Service getService(String servicename, String servicedesc)
    throws Exception {
        if( blcm == null) blcm = this.getBusinessLifeCycleManager();
        if(service == null) {
            service = blcm.createService(servicename);
            service.setDescription(getIS(servicedesc));
        }

        return  service;
    }

    /**
     *  Create a ServiceBinding
     * @param descr
     * @param validateurl  Whether you need to validate the url.
     * @param url
     * @return
     * @throws Exception
     */
    protected ServiceBinding getServiceBinding(String descr, boolean validateurl,
                                               String url)
    throws Exception {
         if( blcm == null) blcm = this.getBusinessLifeCycleManager();
         if( binding == null ){
             binding = blcm.createServiceBinding();
             binding.setDescription(getIS(descr));
             binding.setValidateURI(validateurl);
             binding.setAccessURI(url);
         }

         return binding;
    }

}
