/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.isolation.ejb.a;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

import org.jboss.logging.Logger;
import org.jboss.test.isolation.interfaces.IsolationDTO;
import org.jboss.test.isolation.interfaces.b.SessionB;
import org.jboss.test.isolation.interfaces.b.SessionBHome;
import org.jboss.test.util.Debug;

/**
 * A SessionA.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class SessionAEJB implements SessionBean
{
   private static final Logger log = Logger.getLogger(SessionAEJB.class);
   
   public void invokeSessionB()
   {
      try
      {
         InitialContext ctx = new InitialContext();
         Object o = ctx.lookup("java:comp/env/ejb/SessionB");

         StringBuffer buffer = new StringBuffer("SessionBHome lookup");
         Debug.displayClassInfo(o.getClass(), buffer);
         log.info(buffer.toString());
         buffer = new StringBuffer("My SessionBHome");
         Debug.displayClassInfo(SessionBHome.class, buffer);
         log.info(buffer.toString());
         
         SessionBHome home = (SessionBHome) o;
         SessionB session = home.create();
         
         IsolationDTO dto = new IsolationDTO();
         dto.payload = "hello";
         
         IsolationDTO result = session.sayHello(dto);
         if (dto == result)
            throw new EJBException("Expected pass by value");
         if ("goodbye".equals(result.payload) == false)
            throw new EJBException("Did not get expected 'goodbye'");
      }
      catch (Exception e)
      {
         throw new EJBException(e);
      }
   }
   
   public void ejbCreate() throws CreateException
   {
   }
   
   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }
   
   public void ejbRemove()
   {
   }
   
   public void setSessionContext(SessionContext ctx)
   {
   }
}
