/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.invokers.ejb;

import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import org.jboss.logging.Logger;

/** A simple session bean for testing access via direct rpc and asynch jms.

@author Scott.Stark@jboss.org
@version $Revision:1$
*/
public class BusinessBean implements SessionBean
{
   static Logger log = Logger.getLogger(BusinessBean.class);
   private SessionContext sessionContext;

   public void ejbCreate()
   {
      log.debug("ejbCreate() called");
   }

   public void ejbActivate()
   {
      log.debug("ejbActivate() called");
   }

   public void ejbPassivate()
   {
      log.debug("ejbPassivate() called");
   }

   public void ejbRemove()
   {
      log.debug("ejbRemove() called");
   }

   public void setSessionContext(SessionContext context)
   {
      sessionContext = context;
   }

   public boolean doSomething()
   {
      log.info("doSomething");
      return true;
   }

   public String doSomethingSlowly(Object arg1, String arg2)
   {
      log.info("doSomethingSlowly, arg1="+arg1);
      try
      {
         Thread.sleep(10 * 1000);
      }
      catch(Exception ex)
      {
         throw new EJBException(ex);
      }
      String result = arg2 + " - " + new Date();
      log.info("Result: "+result);
      return result;
   }

}
