/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.idgen.ejb;

import java.rmi.*;
import javax.naming.*;
import javax.ejb.*;

import org.jboss.test.util.ejb.SessionSupport;
import org.jboss.test.idgen.interfaces.*;

/**
 *      
 *   @author Rickard Oberg
 *   @author $Author:Robert Worsnop$
 *   @version $Revision:1$
 */
public class IdGeneratorBean
   extends SessionSupport
{
   IdCounterHome counterHome;
   
   static final String SIZE = "java:comp/env/size";

   public long getNewId(String beanName)
      throws RemoteException
   {
      IdCounter counter;
      
      // Acquire counter
      try {
         counter = counterHome.findByPrimaryKey(beanName);
      } 
      catch (FinderException e) {
         try {
            counter = counterHome.create(beanName);
         } catch (CreateException ex) {
            throw new EJBException("Could not find or create counter for "+beanName);
         }
      }
      
      // Get id
      return counter.getNextValue();
   }

   public void setSessionContext(SessionContext context) 
   {
      super.setSessionContext(context);
      
      try {
         counterHome = (IdCounterHome)new InitialContext().lookup("java:comp/env/ejb/IdCounter");
      } 
      catch (Exception e) {
         throw new EJBException(e);
      }
   }
}
