/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
//$Id:Name.java,v 1.0, 2005-06-24 19:12:46Z, Robert Worsnop$
package org.jboss.test.hibernate.model;

import java.io.Serializable;

/**
 * @author Gavin King
 */
public class Name implements Serializable
{
   static final long serialVersionUID = -4063543106619376911L;
   private String firstName;
   private String lastName;
   private Character initial;

   public Name()
   {
   }

   public Name(String first, Character middle, String last)
   {
      firstName = first;
      initial = middle;
      lastName = last;
   }

   public String getFirstName()
   {
      return firstName;
   }

   public void setFirstName(String firstName)
   {
      this.firstName = firstName;
   }

   public Character getInitial()
   {
      return initial;
   }

   public void setInitial(Character initial)
   {
      this.initial = initial;
   }

   public String getLastName()
   {
      return lastName;
   }

   public void setLastName(String lastName)
   {
      this.lastName = lastName;
   }

   public String toString()
   {
      StringBuffer buf = new StringBuffer()
         .append(firstName)
         .append(' ');
      if (initial != null)
         buf.append(initial)
            .append(' ');
      return buf.append(lastName)
         .toString();
   }

}

