/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.exception;

import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

/** Tests of exception propagation via remote and local interfaces
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class ExceptionTesterBean implements SessionBean
{
   private SessionContext ctx;

   public void ejbCreate() throws CreateException
   {
      try
      {
         InitialContext ic = new InitialContext();
         Boolean failInEjbCreate = (Boolean) ic.lookup("java:comp/env/failInEjbCreate");
         if( failInEjbCreate.booleanValue() )
            throw new CreateException("Failed in ejbCreate as requested");
      }
      catch(NameNotFoundException ignore)
      {
         // Assume failInEjbCreate = false
      }
      catch(NamingException e)
      {
         throw new CreateException("Failed to access ENC, "+e.getMessage());
      }
   }

   public void applicationExceptionInTx() throws ApplicationException
   {
      throw new ApplicationException("Application exception from within " +
         " an inherited transaction");
   }

   public void applicationErrorInTx()
   {
      throw new ApplicationError("Application error from within " +
         " an inherited transaction");
   }

   public void ejbExceptionInTx()
   {
      throw new EJBException("EJB exception from within " +
         " an inherited transaction");
   }

   public void runtimeExceptionInTx()
   {
      throw new RuntimeException("Runtime exception from within " +
         " an inherited transaction");
   }

   public void remoteExceptionInTx() throws RemoteException
   {
      throw new RemoteException("Remote exception from within " +
         " an inherited transaction");
   }

   public void applicationExceptionNewTx() throws ApplicationException
   {
      throw new ApplicationException("Application exception from within " +
         " a new container transaction");
   }

   public void applicationErrorNewTx()
   {
      throw new ApplicationError("Application error from within " +
         " an inherited transaction");
   }

   public void ejbExceptionNewTx()
   {
      throw new EJBException("EJB exception from within " +
         " a new container transaction");
   }

   public void runtimeExceptionNewTx()
   {
      throw new RuntimeException("Runtime exception from within " +
         " a new container transaction");
   }

   public void remoteExceptionNewTx() throws RemoteException
   {
      throw new RemoteException("Remote exception from within " +
         " a new container transaction");
   }

   public void applicationExceptionNoTx() throws ApplicationException
   {
      throw new ApplicationException("Application exception without " +
         " a transaction");
   }

   public void applicationErrorNoTx()
   {
      throw new ApplicationError("Application error from within " +
         " an inherited transaction");
   }

   public void ejbExceptionNoTx()
   {
      throw new EJBException("EJB exception without " +
         " a transaction");
   }

   public void runtimeExceptionNoTx()
   {
      throw new RuntimeException("Runtime exception without " +
         " a transaction");
   }

   public void remoteExceptionNoTx() throws RemoteException
   {
      throw new RemoteException("Remote exception without " +
         " a transaction");
   }

   public void securityExceptionByAppNoTx() 
         throws GeneralSecurityException
   {
      // This exception should be propagated as is
      throw new GeneralSecurityException("securityExceptionByAppNoTx");
   }

   public void securityExceptionNoTx()
   {
      // The method permissions should cause the security exception
   }

   public void setSessionContext(SessionContext ctx)
   {
      this.ctx = ctx;
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }
}
