/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.exception;

import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import javax.ejb.EJBObject;


/** A remote interface used for testing propagation of exceptions back to a
 * remote client.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */ 
public interface ExceptionTester extends EJBObject
{
   public void applicationExceptionInTx() 
         throws ApplicationException, RemoteException;
   public void applicationErrorInTx() throws RemoteException;
   public void ejbExceptionInTx() throws RemoteException;
   public void runtimeExceptionInTx() throws RemoteException;
   public void remoteExceptionInTx() throws RemoteException;
   
   public void applicationExceptionNewTx() 
         throws ApplicationException, RemoteException;
   public void applicationErrorNewTx() throws RemoteException;
   public void ejbExceptionNewTx() throws RemoteException;
   public void runtimeExceptionNewTx() throws RemoteException;
   public void remoteExceptionNewTx() throws RemoteException;

   public void applicationExceptionNoTx() 
         throws ApplicationException, RemoteException;
   public void applicationErrorNoTx() throws RemoteException;
   public void ejbExceptionNoTx() throws RemoteException;
   public void runtimeExceptionNoTx() throws RemoteException;
   public void remoteExceptionNoTx() throws RemoteException;

   public void securityExceptionNoTx() 
         throws RemoteException;
   public void securityExceptionByAppNoTx() 
         throws GeneralSecurityException, RemoteException;
}
