/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cts.test;

import javax.naming.Context;
import javax.naming.InitialContext;

import junit.framework.Test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.cts.interfaces.StatelessSession;
import org.jboss.test.cts.interfaces.StatelessSessionHome;

/** Tests of stateful session beans
 *
 *   @author kimptoc 
 *   @author Scott.Stark@jboss.org 
 *   @author d_jencks converted to JBossTestCase, added logging.
 *   @version $Revision:1$
 */
public class StatefulSessionLocalUnitTestCase
   extends JBossTestCase
{

   public StatefulSessionLocalUnitTestCase (String name)
   {
      super(name);
   }

   /** Create a StatefulSessionBean and then force passivation by waiting
    for 45 seconds.
    This relies on a custom container config that specifies
    container-cache-conf/cache-policy-conf/remover-period=65
    container-cache-conf/cache-policy-conf/overager-period=40
    container-cache-conf/cache-policy-conf/max-bean-age=30
    container-cache-conf/cache-policy-conf/max-bean-life=60
     */
   public void testPassivationByTimeLocal() throws Exception
   {
      Context ctx = new InitialContext();
      getLog().debug("+++ testPassivationByTimeLocal");
      StatelessSessionHome sessionHome = ( StatelessSessionHome ) ctx.lookup("ejbcts/StatelessSessionHome");
      StatelessSession session = sessionHome.create();
      session.testPassivationByTimeLocal();
      getLog().debug("--- testPassivationByTimeLocal");
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(StatefulSessionLocalUnitTestCase.class, "cts.jar");
   }
}
