/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.enums.test;

import net.sourceforge.junitejb.EJBTestCase;
import junit.framework.Test;
import org.jboss.test.JBossTestCase;
import org.jboss.test.cmp2.enums.ejb.Facade;
import org.jboss.test.cmp2.enums.ejb.FacadeUtil;
import org.jboss.test.cmp2.enums.ejb.ColorEnum;
import org.jboss.test.cmp2.enums.ejb.IDClass;

/**
 *
 * @author <a href="mailto:alex@jboss.org">Alex Loubyansky</a>
 */
public class EnumUnitTestCase
   extends EJBTestCase
{
   public static Test suite() throws Exception
   {
      return JBossTestCase.getDeploySetup(EnumUnitTestCase.class, "cmp2-enum.jar");
   }

   public EnumUnitTestCase(String s)
   {
      super(s);
   }

   // Tests

   public void testEnum()
      throws Exception
   {
      Facade facade = FacadeUtil.getHome().create();
      final IDClass id = new IDClass(1);
      facade.createChild(id);
      assertTrue(ColorEnum.RED == facade.getColorForId(id));
      facade.setColor(id, ColorEnum.GREEN);
      assertTrue(ColorEnum.GREEN == facade.getColorForId(id));
      facade.setColor(id, ColorEnum.BLUE);
      assertTrue(ColorEnum.BLUE == facade.getColorForId(id));
   }
}
