/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cmp2.commerce;

import java.util.Collection;
import javax.ejb.EntityBean; 
import javax.ejb.EntityContext; 
import javax.ejb.CreateException;

import org.jboss.varia.autonumber.AutoNumberFactory;

public abstract class ProductCategoryBean implements EntityBean {
	transient private EntityContext ctx;

	public CompositeId ejbCreate() throws CreateException {
      setId(AutoNumberFactory.getNextInteger("ProductCategory").longValue());
      setSubId(AutoNumberFactory.getNextInteger("ProductCategory").longValue());
		return null;
	}

	public void ejbPostCreate() { }

   public abstract long getId();
   public abstract void setId(long id);

   public abstract long getSubId();
   public abstract void setSubId(long id);

	public abstract String getName();
	public abstract void setName(String name);

   public abstract Collection getProducts();
   public abstract void setProducts(Collection girth);

   public abstract ProductCategory getParent();
   public abstract void setParent(ProductCategory parent);
   public abstract Collection getSubcategories();
   public abstract void setSubcategories(Collection subcategories);

   public abstract ProductCategoryType getType();
   public abstract void setType(ProductCategoryType type);

   public CompositeId getPK()
   {
      return (CompositeId)ctx.getPrimaryKey();
   }

	public void setEntityContext(EntityContext ctx) { this.ctx = ctx; }
	public void unsetEntityContext() {
		this.ctx = null;
	}
	public void ejbActivate() { }
	public void ejbPassivate() { }
	public void ejbLoad() { }
	public void ejbStore() { }
	public void ejbRemove() { }
}
