/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.cmrtree.ejb;

import org.apache.log4j.Category;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;

/**
 * @ejb:bean type="Stateless"
 * name="Facade"
 * view-type="remote"
 * @ejb.util generate="physical"
 * @ejb:transaction type="Required"
 * @ejb:transaction-type type="Container"
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class FacadeSessionBean
   implements SessionBean
{
   private static Category log = Category.getInstance(FacadeSessionBean.class);

   SessionContext ctx;

   // Business methods

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void setup() throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.debug("SETUP>");

      ALocal a = AUtil.getLocalHome().create(1, "A", "1.A");
      BLocal b1 = BUtil.getLocalHome().create(1, "B1", "1.B1");
      b1.setAMinorId("A");

      BLocal b2 = BUtil.getLocalHome().create(1, "B2", "1.B2");
      b2.setParent(b1);

      log.debug("SETUP> done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void test(long sleep) throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.debug("RUN>");

      AUtil.getLocalHome().remove(new APK(1, "A"));

      log.debug("RUN> done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

   /**
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
   public void tearDown() throws Exception
   {
      final long startTime = System.currentTimeMillis();
      log.debug("TEAR DOWN>");

      log.debug("TEAR DOWN> done in " + (System.currentTimeMillis() - startTime) + " ms.");
   }

   // SessionBean implementation

   /**
    * @throws CreateException Description of Exception
    * @ejb.create-method
    */
   public void ejbCreate() throws CreateException
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }

   public void setSessionContext(SessionContext ctx)
   {
      this.ctx = ctx;
   }
}
